import React, {useEffect, useState} from 'react';
import Table from '@mui/material/Table';
import TableBody from '@mui/material/TableBody';
import TableCell from '@mui/material/TableCell';
import TableContainer from '@mui/material/TableContainer';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import Paper from '@mui/material/Paper';
import {Button} from "@mui/material";
import {Link} from "react-router-dom";

const BigTable = () => {
  function createData(id, nome, regione, citta) {
    return { id, nome, regione, citta };
  }
  const axios = require('axios')

  const [table, setTable] = useState([])

  useEffect(() => {
    const getTable = async () => {
      const response = await axios.get('https://ooxvks6089.execute-api.eu-south-1.amazonaws.com/dev/test/facility')
      setTable(response.data)
    }
    getTable()
  }, [])

  return (
    <div>
      <TableContainer component={Paper}>
        <Table  sx={{maxWidth: 900}} aria-label="simple table">
          <TableHead>
            <TableRow>
              <TableCell>ID</TableCell>
              <TableCell align="right">Nome</TableCell>
              <TableCell align="right">Regione</TableCell>
              <TableCell align="right">Città</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {table.map((row) => (
              <TableRow
                key={row.uuid}
                sx={{ '&:last-child td, &:last-child th': { border: 0 } }}
              >
                <TableCell component="th" scope="row">{row.id}</TableCell>
                <TableCell align="right">{row.name}</TableCell>
                <TableCell align="right">{row.region}</TableCell>
                <TableCell align="right">{row.city}</TableCell>
                <TableCell align="right">
                  <Link style={{textDecoration:'none'}} to={`/Details/${row.uuid}`}>
                    <Button variant="contained">Dettaglio</Button>
                  </Link>
                </TableCell>

              </TableRow>
            ))}
          </TableBody>
        </Table>
      </TableContainer>
    </div>
  );
};

export default BigTable;


