import React, {useEffect, useState} from 'react';
import { useParams} from "react-router-dom";
import axios from "axios";
import TableContainer from "@mui/material/TableContainer";
import Paper from "@mui/material/Paper";
import Table from "@mui/material/Table";
import TableHead from "@mui/material/TableHead";
import TableRow from "@mui/material/TableRow";
import TableCell from "@mui/material/TableCell";
import TableBody from "@mui/material/TableBody";
import {Button} from "@mui/material";

function CardDetail({handleOpen,detail}) {
  return(
    <div>
      {/* Details*/}
      <TableContainer component={Paper}>
        <Table sx={{maxWidth: 900}} aria-label="simple table">
          <TableHead>
            <TableRow>
              <TableCell align="left">Country</TableCell>
              <TableCell align="left">City</TableCell>
              <TableCell align="left">District</TableCell>
              <TableCell align="left">Name</TableCell>
              <TableCell align="left">Phone</TableCell>
              <TableCell align="left">Region</TableCell>
              <TableCell align="left">Zip Code</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            <TableRow
              key={detail.id}
              sx={{ '&:last-child td, &:last-child th': { border: 0 } }}
            >
              <TableCell component="th" scope="row">{detail.country}</TableCell>
              <TableCell align="left">{detail.city}</TableCell>
              <TableCell align="left">{detail.district}</TableCell>
              <TableCell align="left">{detail.name}</TableCell>
              <TableCell align="left">{detail.phone}</TableCell>
              <TableCell align="left">{detail.region}</TableCell>
              <TableCell align="left">{detail.zip_code}</TableCell>
              <TableCell align="right">
                <Button variant="contained" size={'small'} handleOpen={handleOpen} onClick={handleOpen}>Modifica</Button>
              </TableCell>
            </TableRow>
          </TableBody>
        </Table>
      </TableContainer>
    </div>
  )
}

export default CardDetail;